﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Schema;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Utilities;
using ext = Ext.Net;

public partial class portal_start : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }

    [ext.DirectMethod(ShowMask = true, Msg = "Please wait")]
    /// <summary>
    /// Get patient appointments
    /// </summary>
    public object GetPatientAppointments() 
    {
        var obj = new { };
        CCPA ccpa = new CCPA();
        DataSet dsApp = ccpa.GetPatPWEventDS(Master, Master.SelectedPatientID);
        if(dsApp != null){
            foreach (DataTable dt in dsApp.Tables) {
                foreach (DataRow dr in dt.Rows) {
                    if (!dr.IsNull("EVENT_TITLE")) {
                        string strEventTitle = Regex.Replace(dr["EVENT_TITLE"].ToString(), ".*\\((.+)\\).*", "$1");
                        dr["EVENT_TITLE"] = strEventTitle;
                    }
                }
            }
            dsApp.AcceptChanges();

            var a = JsonConvert.DeserializeObject(JsonConvert.SerializeObject(dsApp.Tables[0], Formatting.Indented));
            return a;
        }

        //return the object
        return obj;
    }
}